﻿using System;
using System.Drawing;
using System.Collections.Generic;
using System.Text;

using SdlDotNet.Core;
using SdlDotNet.Graphics;
using SdlDotNet.Graphics.Sprites;
using SdlDotNet.Audio;
using System.Threading;

namespace BoucingBall
{
    class Program
    {
        private BouncingSprite _BallSprite;
        private Sound soundstart = new Sound("start.wav");
        private Sound soundend = new Sound("end.wav");

        [STAThread]
        static void Main()
        {
            Program bb = new Program();
            bb.Run();
        }

        public Program()
        {
            Video.SetVideoMode(640, 480);
            Video.WindowCaption = "Bouncing Ball";
            _BallSprite = new BouncingSprite("ball.png", "ball.wav", Video.Screen.Width, Video.Screen.Height, 5, 5);
        }

        public void Run()
        {
            soundstart.Play();
            Events.Quit += new EventHandler<QuitEventArgs>(this.Quit);
            Events.Tick += new EventHandler<TickEventArgs>(this.OnTick);
            Events.Run();
        }

        public void Quit(object sender, QuitEventArgs e)
        {
            soundend.Play();
            Thread.Sleep(1500); 
            Events.QuitApplication();
        }

        public void OnTick(object sender, TickEventArgs e)
        {
            _BallSprite.NextStep();
            Video.Screen.Fill(Color.Black);
            Video.Screen.Blit(_BallSprite);
            Video.Screen.Update();
        }
    }

    public class BouncingSprite : Sprite
    {
        private int _screenWidth;
        private int _screenHeight;
        private int _speedX;
        private int _speedY;
        //Declare _sound as a Sound class
        private Sound _sound;

        public BouncingSprite(string imageFilePath, string audioFilePath, int screenWidth, int screenHeight, int speedX, int speedY)
            : base(imageFilePath)
        {
            _screenWidth = screenWidth;
            _screenHeight = screenHeight;
            _speedX = speedX;
            _speedY = speedY;
            //Sound effect when the ball hits the edge of the screen
            _sound = new Sound(audioFilePath);
        }

        public void NextStep()
        {
            this.X += _speedX;
            this.Y += _speedY;
            if (this.X < 0)
            {
                _speedX = _speedX * -1;
                this.X = 0;
                //Play the sound effect
                _sound.Play();
            }
            if (this.X > _screenWidth - this.Width)
            {
                _speedX = _speedX * -1;
                this.X = _screenWidth - this.Width;
                //Play the sound effect
                _sound.Play();
            }
            if (this.Y < 0)
            {
                _speedY = _speedY * -1;
                this.Y = 0;
                //Play the sound effect
                _sound.Play();
            }
            if (this.Y > _screenHeight - this.Height)
            {
                _speedY = _speedY * -1;
                this.Y = _screenHeight - this.Height;
                //Play the sound effect
                _sound.Play();
            }
        }
    }
}